---
title: Common use cases for custom rules · Cloudflare Web Application Firewall
  (WAF) docs
description: "The following common use cases illustrate how to secure web
  traffic to your sites and applications with custom rules:"
lastUpdated: 2025-07-09T14:24:57.000Z
chatbotDeprioritize: true
source_url:
  html: https://developers.cloudflare.com/waf/custom-rules/use-cases/
  md: https://developers.cloudflare.com/waf/custom-rules/use-cases/index.md
---

The following common use cases illustrate how to secure web traffic to your sites and applications with custom rules:

* [Allow traffic from IP addresses in allowlist only](https://developers.cloudflare.com/waf/custom-rules/use-cases/allow-traffic-from-ips-in-allowlist/)
* [Allow traffic from search engine bots](https://developers.cloudflare.com/waf/custom-rules/use-cases/allow-traffic-from-verified-bots/)
* [Allow traffic from specific countries only](https://developers.cloudflare.com/waf/custom-rules/use-cases/allow-traffic-from-specific-countries/)
* [Block Microsoft Exchange Autodiscover requests](https://developers.cloudflare.com/waf/custom-rules/use-cases/block-ms-exchange-autodiscover/)
* [Block requests by attack score](https://developers.cloudflare.com/waf/custom-rules/use-cases/block-attack-score/)
* [Block traffic by geographical location](https://developers.cloudflare.com/waf/custom-rules/use-cases/block-by-geographical-location/)
* [Block traffic from specific countries](https://developers.cloudflare.com/waf/custom-rules/use-cases/block-traffic-from-specific-countries/)
* [Build a sequence rule within custom rules](https://developers.cloudflare.com/waf/custom-rules/use-cases/sequence-custom-rules/)
* [Challenge bad bots](https://developers.cloudflare.com/waf/custom-rules/use-cases/challenge-bad-bots/)
* [Configure token authentication](https://developers.cloudflare.com/waf/custom-rules/use-cases/configure-token-authentication/)
* [Exempt partners from Hotlink Protection](https://developers.cloudflare.com/waf/custom-rules/use-cases/exempt-partners-hotlink-protection/)
* [Issue challenge for admin user in JWT claim based on attack score](https://developers.cloudflare.com/waf/custom-rules/use-cases/check-jwt-claim-to-protect-admin-user/)
* [Require a specific cookie](https://developers.cloudflare.com/waf/custom-rules/use-cases/require-specific-cookie/)
* [Require known IP addresses in site admin area](https://developers.cloudflare.com/waf/custom-rules/use-cases/site-admin-only-known-ips/)
* [Require specific HTTP headers](https://developers.cloudflare.com/waf/custom-rules/use-cases/require-specific-headers/)
* [Require specific HTTP ports](https://developers.cloudflare.com/waf/custom-rules/use-cases/require-specific-http-ports/)
* [Stop R-U-Dead-Yet? (R.U.D.Y.) attacks](https://developers.cloudflare.com/waf/custom-rules/use-cases/stop-rudy-attacks/)
* [Update custom rules for customers or partners](https://developers.cloudflare.com/waf/custom-rules/use-cases/update-rules-customers-partners/)
